/* AUSTIME2.REXX Convert to time in Australia NSW */
/* Copyright 1994 by Merrill Callaway             */
PARSE ARG help
IF help = '?' THEN DO
   say 'AusTime2 copyright 1994 by Merrill Callaway'
   say 'Program outputs table of times in Mountain Time'
   say 'with corresponding time/day in Sydney, Australia.'
   say 'Automatic seasonal adjustments for Daylight Time here/there.'
   say 'Shows only those times of day that MCI International'
   say 'calling service is discounted (from America).'
   say 'If "Y" or "yes" is given for Business Hours?'
   say 'Then only those times in Sydney are displayed that'
   say 'fall between 8 AM and 5 PM Sydney time, on a business day.'
   say 'Adjusts for business hours when calling from USA on Friday-Sunday.'
   say 'shows more business hours there on Monday if calling on Sunday.'
   say 'Calling on Friday for business hours generates a warning'
   say 'that Saturday may not be a business day, and calling on'
   say 'Saturday will not let you ask for business hours there on Sunday.'
   say ''
   end
datenow=DATE()
PARSE VAR datenow day month year
leap=0
IF year//4=0 THEN leap=1
daynow=DATE(d)
IF (daynow>93+leap) & (daynow< 303 + leap) THEN add=16
ELSE add=18
SAY 'Business hours?'
PULL answer
IF abbrev(answer,'Y') THEN biz=1;else biz=0

today=DATE(w)
SELECT
   WHEN today='Monday' THEN tomorrow='Tuesday'
   WHEN today='Tuesday' THEN tomorrow='Wednesday'
   WHEN today='Wednesday' THEN tomorrow='Thursday'
   WHEN today='Thursday' THEN tomorrow='Friday'
   WHEN today='Friday' THEN DO
      tomorrow='Saturday'
      weekend=caution
   END
   WHEN today='Saturday' THEN DO
      tomorrow='Sunday'
      weekend=noway
   END
   WHEN today='Sunday' THEN DO
      tomorrow='Monday'
      weekend=ok
   END
   OTHERWISE NOP
END

IF weekend=caution THEN SAY 'Caution! Saturday may NOT be a workday.'
IF weekend=noway & biz THEN DO
   SAY 'NO Business on Sunday!'
   SAY 'Do not ask for business hours.'
   CALL austime2.rexx
   EXIT
END
DO hours=1 TO 24
   IF hours>13 & hours<22 THEN prefix='';ELSE prefix='CALLPAC'
   timenow=hours
   daynow=today
   IF hours = 24 THEN daynow=tomorrow
   IF hours+add<24  THEN DO
      hoursthere=hours+add
      daythere=today'.'
   END
   ELSE DO
      hoursthere=(hours+add)//24
      daythere=tomorrow'.'
   END
   IF timenow=24 THEN timenow=0
   IF biz then if hoursthere>8 & hoursthere<17 THEN DO
      IF prefix~='' | weekend=OK THEN,
          SAY 'Here: 'format(timenow,2,2) daynow' ==> Australia: 'format(hoursthere,2,2) daythere
   END
   IF ~biz THEN if prefix~='' | weekend=OK then,
       SAY 'Here: 'format(timenow,2,2) daynow' ==> Australia: 'format(hoursthere,2,2) daythere
END
EXIT

format: PROCEDURE
PARSE ARG num, before, after
num=RIGHT(num,before,0)
num=num||':'COPIES('0',after)
RETURN num